*use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Paid_Leave\CPS Data\cps_data_full.dta", clear 
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Paid_Leave\CPS Data\cps_data_full_v2.dta", clear 



/*
*some very preliminary summaries 
gen is_family_leave = 0 
replace is_family_leave = 1 if whyabsnt == 8 
egen id_empstat = group(empstat) 
by id_empstat, sort: gen test2 = _n 
br id_empstat empstat if test2 == 1

/* id_empstat	empstat
1	NIU
2	Armed Forces
3	At work
4	Has job, not at work last week
5	Unemployed, experienced worker
6	Unemployed, new worker
7	NILF, unable to work
8	NILF, other
9	NILF, retired
*/


keep if (id_empstat == 3 | id_empstat == 4)
keep if sex == 2
by statefip year, sort: egen proportion_leave = wtmean(is_family_leave), weight(wtsupp)

by statefip year, sort: gen output_indicator = _n 
br year proportion_leave if output_indicator == 1 & statefip == 06 

br empstat if empstat == 3
*/

*** first generate treatment and control sample 
*** only keep women 
keep if sex == 2
keep if yngch < 18 
keep if statefip == 06
*** change to the below for falsification test 
*keep if statefip == 44 | statefip == 36 | statefip == 15 
**keep if workly == 02
keep if uhrsworkly != 999 
keep if year <= 2010 
*** just to replicate theirs, we drop recent years

*** first treatment they use is child less than 1 vs. child ages 5-17 
gen is_treated = . 
replace is_treated = 1 if yngch < 1
replace is_treated = 0 if (yngch >= 5 & yngch <= 17)
keep if is_treated != . 
br if statefip == 6 & year >= 2005 & is_treated == 0 
br if is_treated != . 

*** now let's generate age variables for mother
capture drop mother_age
gen mother_age = . 
replace mother_age = 1 if age < 20
replace mother_age = 2 if (age >= 20 & age < 30)
replace mother_age = 3 if (age >= 30 & age < 40)
replace mother_age = 4 if (age >= 40 & age < 50)
replace mother_age = 5 if (age >= 50 & age < 60)
replace mother_age = 6 if (age >= 60)

br age if mother_age == . 

*** now education
gen mother_ed = . 
*** less HS
replace mother_ed = 1 if (educ >= 002 & educ < 073)
*** HS degree
replace mother_ed = 2 if (educ == 073)
*** Some college
replace mother_ed = 3 if (educ > 073 & educ < 111)
*** college + 
replace mother_ed = 4 if (educ >= 111 & educ < 999)
br educ if mother_ed == . 

*** now race 
gen hispanic = 1
replace hispanic = 0 if (hispan == 000 | hispan == 901 | hispan == 902)
replace hispanic = . if (hispan == 901 | hispan == 902)
*** non-hispanic white 
gen race_ethnic = 4
replace race_ethnic = 1 if (race == 100 & hispanic == 0)
replace race_ethnic = 2 if (race == 200 & hispanic == 0)
replace race_ethnic = 3 if (hispanic == 1)
replace race_ethnic = . if race == 999 

*** now marital status 
gen marital_status = . 
replace marital_status = 1 if (marst == 1 | marst == 2)
*** married
replace marital_status = 2 if (marst == 3)
*** separated
*** divorced
replace marital_status = 3 if (marst == 4)

*** widowed 
replace marital_status = 4 if (marst == 5)

*** never marry 
replace marital_status = 4 if (marst == 6)


*** now absent from job
gen why_absent = . 
*** maternity leave
replace why_absent = 1 if whyabsnt == 09 
replace why_absent = 2 if (whyabsnt != 00 & whyabsnt != 09)
*** non-paternity leave
*** total 
gen total_leave =  0
replace total_leave = 1 if whyabsnt != 00 

gen maternity_leave = 0 
replace maternity_leave = 1 if why_absent == 1 

*** alternate leave
gen alternate_leave = 0 
replace alternate_leave = 1 if why_absent == 2 

*** birthplace
gen birthplace = 0 
replace birthplace = 1 if bpl == 09900
replace birthplace = . if bpl >= 96000

*** firmsize
gen firmsize_indicator_pre2011 = . 
replace firmsize_indicator_pre2011 = 1 if firmsize == 1
replace firmsize_indicator_pre2011 = 2 if firmsize == 2
*** this is for 10-24
replace firmsize_indicator_pre2011 = 3 if firmsize == 5
*** this is for 25-99
replace firmsize_indicator_pre2011 = 4 if firmsize == 7
*** 100-499 
replace firmsize_indicator_pre2011 = 5 if firmsize == 8 
replace firmsize_indicator_pre2011= 6 if firmsize == 9 

/*
*** firmsize post-2011
gen firmsize_indicator_post2011 = . 
replace firmsize_indicator_post2011 = 1 if firmsize == 1
replace firmsize_indicator_post2011 = 2 if firmsize == 4
*** this is for 10-49 
replace firmsize_indicator_post2011 = 3 if firmsize == 6
*** this is for 50-99
replace firmsize_indicator_post2011 = 4 if firmsize == 7 
*** 100-499 
replace firmsize_indicator_post2011 = 5 if firmsize == 8 
replace firmsize_indicator_post2011 = 6 if firmsize == 9 
*/

gen post = . 
replace post = 1 if year >= 2005 
replace post = 0 if year < 2005 

gen is_treated_post = is_treated*post 

*** race, educ variable for subgroup analysis 

gen white = 0 
replace white = 1 if race_ethnic == 1

gen black = 0 
replace black = 1 if race_ethnic == 2

gen hisp = 0 
replace hisp = 1 if race_ethnic == 3

gen other = 0
replace other = 1 if race_ethnic == 4 

gen married = 0 
replace married = 1 if marital_status == 1

gen sep = 0 
replace sep = 1 if marital_status == 2

gen div = 0 
replace div = 1 if marital_status == 3

gen widow = 0 
replace widow = 1 if marital_status == 4

gen less_hs = 0 
replace less_hs = 1 if mother_ed == 1

gen hs = 0 
replace hs = 1 if mother_ed == 2

gen some_coll = 0 
replace some_coll = 1 if mother_ed == 3 

gen college = 0 
replace college = 1 if mother_ed == 4 

gen maternity = 0 
replace maternity = 1 if why_absent == 1

gen maternity_broad = 0 
replace maternity_broad = 1 if (why_absent == 1 | why_absent == 2)

gen broad = 0 
replace broad = 1 if why_absent == 2

*** note, can't use replicate weights bc they don't exist for pre-2005 

reg maternity_leave is_treated is_treated_post i.year i.marital_status i.race_ethnic i.mother_ed i.age birthplace 



**** regressions by educ level 


*** hs or less
eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if ((is_treated == 1 & post == 0) & (less_hs == 1 | hs == 1))
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (less_hs == 1 | hs == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hs


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (less_hs == 1 | hs == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (less_hs == 1 | hs == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hs_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (less_hs == 1 | hs == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (less_hs == 1 | hs == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hs_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 
 


*** some coll
eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (some_coll == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (some_coll == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_somecoll


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (some_coll == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (some_coll == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_somecoll_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (some_coll == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (some_coll == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_somecoll_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

*** coll or more 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (college == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (college == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_coll


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (college == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (college == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_coll_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (college == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (college == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_coll_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.mother_ed i.age i.yngch birthplace [pweight=wtsupp]
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_paid


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.mother_ed *.age *.yngch birthplace) replace 

*** unmarried 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 0)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 0)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_unmarried


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 0) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 0) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_unmarried_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 0) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 0) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_unmarried_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 


*** married  

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_married


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_married_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (married == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.race_ethnic i.age i.yngch birthplace [pweight=wtsupp] if (married == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_married_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.race_ethnic *.age *.yngch birthplace) replace 


*** white

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (white == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (white == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_white


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (white == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (white == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_white_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (white == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (white == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_white_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 


*** black 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (black == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (black == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_black


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (black == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (black == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_black_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (black == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (black == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_black_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 


*** hispanic 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (hisp == 1)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (hisp == 1)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hisp


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (hisp == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (hisp == 1) & (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hisp_small


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (hisp == 1) & (firmsize_indicator_pre2011 >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.mother_ed i.marital_status i.age i.yngch birthplace [pweight=wtsupp] if (hisp == 1) & (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_hisp_large


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.mother_ed *.marital_status *.age *.yngch birthplace) replace 



/****BASELINE

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.mother_ed i.age i.yngch birthplace [pweight=wtsupp]
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate
local f C:\Users\Public\baseline_paid_replicate_false


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.mother_ed *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (firmsize == 1 | firmsize == 2)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.mother_ed i.age i.yngch birthplace [pweight=wtsupp] if (firmsize_indicator_pre2011 == 1 | firmsize_indicator_pre2011 == 2)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate_small
local f C:\Users\Public\baseline_paid_replicate_small_false


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.mother_ed *.age *.yngch birthplace) replace 

eststo clear
foreach v in maternity_leave total_leave alternate_leave{
su `v' if (is_treated == 1 & post == 0) & (firmsize >= 4)
capture drop mean_1
gen mean_1 = r(mean)
eststo: quietly reg `v' is_treated is_treated_post i.year i.marital_status i.race_ethnic i.mother_ed i.age i.yngch birthplace [pweight=wtsupp] if (firmsize_indicator_pre2011 >= 4)
estadd scalar valuesof mean_1
}

*local f C:\Users\Public\baseline_paid_replicate_large
local f C:\Users\Public\baseline_paid_replicate_large_false


capture erase `f'
esttab using `f', star(* 0.10 ** 0.05 *** 0.01) b(a) se(a) stats(r2 N valuesof) drop (*.year *.marital_status *.race_ethnic *.mother_ed *.age *.yngch birthplace) replace 
*/
